/* approach4.cpp shows a final approach that "wraps" approach 3 (BST.h)
 *  in a BinarySearchTree class to provide a clean interface.
 *
 * This code may be freely copied and distributed, provided this
 * notice is included.
 *
 * Joel Adams, February 7, 2000.
 */

#include "BST.h"

/*********** BinarySearchTree ***************************/

class BinarySearchTree
{
public:
  BinarySearchTree();
  bool isEmpty() const;
  void insert(const BSTElem & elem);
  void remove(const BSTElem & elem);
  void printSideways(ostream & out = cout) const;
private:

  BST * myBST;
};

BinarySearchTree::BinarySearchTree()
{
  myBST = new EmptyBST(myBST);
}

bool BinarySearchTree::isEmpty() const
{
  return myBST->isEmpty();
}

void BinarySearchTree::insert(const BSTElem & elem)
{
  myBST->insert(elem);
}

void BinarySearchTree::remove(const BSTElem & elem)
{
  myBST->remove(elem);
}

void BinarySearchTree::printSideways(ostream & out) const
{
  myBST->printSideways(out);
}

// *********************** main ****************************
int main()
{
  BinarySearchTree theTree;

  theTree.printSideways();
  cout << "\n----------------------------------\n" << endl;
  
  theTree.insert(4);
  theTree.insert(2);
  theTree.insert(6);
  theTree.insert(1);
  theTree.insert(3);
  theTree.insert(5);
  theTree.insert(7);
  theTree.printSideways();

  cout << "--- removing 4 -------------------------------" << endl;
  theTree.remove(4);
  theTree.printSideways();

  cout << "--- removing 3 -------------------------------" << endl;
  theTree.remove(3);
  theTree.printSideways();

  cout << "--- removing 6 -------------------------------" << endl;
  theTree.remove(6);
  theTree.printSideways();
}


